<?xml version="1.0" encoding="utf-8"?><!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>
<xsl:template match="/MediaCoderReport">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<title>Report</title>
<style>
th, td {
font-size:12px;
font-family:Verdana;
height:24px;
};
</style>
</head>
<body>
<table border="1" cellspacing="0" width="100%">
<tr><th>Path</th>
  <th>Type</th>
  <th>Mime-Type</th>
  <th>Size</th>
  <th>Duration</th>
  <th>Stream</th>
  <th>State</th>
  <th>Speed</th>
  <th>URL</th></tr>
<xsl:for-each select="item">
<tr><td><xsl:value-of select="path"/></td>
<td align="center"><xsl:value-of select="type"/></td>
<td align="center"><xsl:value-of select="mimetype"/></td>
<td align="center"><xsl:if test="size!=-1"><xsl:value-of select="size"/> KB</xsl:if></td>
<td align="center"><xsl:value-of select="duration"/></td>
<td><xsl:for-each select="info/video">
<div><a href="#" onclick="nextSibling.style.display=nextSibling.style.display=='block'?'none':'block'">Video (<xsl:value-of select="@id"/>)</a><div style="display:none">
<xsl:value-of select="codec"/><br/><xsl:value-of select="width"/>x<xsl:value-of select="height"/>@<xsl:value-of select="fps"/>fps<br/><xsl:value-of select="bitrate"/> Kbps</div><br/></div>
</xsl:for-each>
<xsl:for-each select="info/audio">
<div><a href="#" onclick="nextSibling.style.display=nextSibling.style.display=='block'?'none':'block'">Audio (<xsl:value-of select="@id"/>)</a><div style="display:none">
<xsl:value-of select="codec"/><br/><xsl:value-of select="samplerate"/>Hz&nbsp;<xsl:value-of select="channels"/>ch<br/><xsl:value-of select="bitrate"/> Kbps</div><br/></div>
</xsl:for-each></td>
<td align="center"><xsl:if test="done=1">Done</xsl:if></td>
<td align="center"><xsl:if test="benchmark">
<xsl:value-of select="benchmark/speed"/>x 
</xsl:if>
</td>
<td><a target="_blank"><xsl:attribute name="href"><xsl:value-of select="url"/></xsl:attribute><xsl:value-of select="url"/></a></td>
</tr>
</xsl:for-each>
</table>
</body>
</html>

</xsl:template>
</xsl:stylesheet>